unit tout;

interface

uses windows, controls, ComCtrls, SysUtils, StrUtils, Classes,
     Dialogs, ZipForge, Forms;

type
    entree_fat=record
        numero : integer;               // Numro de l'entre dans la liste (0=racine)
        parent : integer;               // Numro de l'entre du rpertoire parent (0=racine)
        nom : string;                   // Nom de l'entre
        sorte : string;                 // Type d'entre 'dir' ou 'file'
        taille : longint;               // Taille en octets
        heure : string;                 // Heure de la dernire modification
        date : string;                  // Date de la dernire modification
        attributs : byte;               // Attributs de l'entre
        premier_cluster : smallint;     // Premier cluster
        adresse_declaration : integer;  // Adresse de dclaration de l'entre
        chemin:string;                  // Chemin complet d'accs au fichier ou au dossier
    end;

    imagedisk=record
        nomfichier : string;            // Nom du fichier image
        nomfichier_zip : string;        // Nom du fichier image compress
        nomimage : string;              // Nom de volume de l'image
        sorte : string;                 // Type de fichier image 'st' ou 'msa'
        nbsecteurs : smallint;          // Nombre de secteurs
        nbfaces : smallint;             // Nombre de faces
        nbfats : smallint;              // Nombre de FATs
        secteurs_par_cluster : smallint;// Nombre de secteurs par cluster
        taille_secteur : smallint;      // Nombre d'octets par secteur
        secteurs_par_fat : smallint;    // Nombre de secteurs par FAT
        piste_depart : smallint;        // Premire piste de l'image
        piste_fin : smallint;           // Dernire piste de l'image
        adr_debut_rep : smallint;       // Adresse du dbut du rpertoire racine
        entrees_rep_principal:smallint; // Nombre d'entres maximum du rpertoire racine
        taille_cluster:smallint;        // Taille d'un cluster en octets
        taille : longint;               // Taille de l'image en octets
        donnees : array of byte;        // Donnes de l'image
        fichier_ok : boolean;           // Validation fichier charg
        contenu_img:array of entree_fat;// Entres de l'image disque (fichiers et rpertoires)
        modif : boolean;                // Image disque en cours de modification
        nb_entrees_fat : integer;       // Nombre d'entres dans le tableau contenu_img
    end;

    p_entree_fat=^entree_fat;
    p_imagedisk=^imagedisk;

//Gestion des chaines de caractres
function extraire_nom_fichier(nomfichier: String): String; forward;
function extraire_debut_nom_fichier(nomfichier: String): String; forward;
function extraire_repertoire(nomfichier: String): String; forward;
function extraire_type_fichier(nomfichier: String): String; forward;
function nom_zip(nom_fichier_sour:string):string; forward;
//Chargement/sauvegarde des images disques
procedure charge_image_disque(image:p_imagedisk); forward;
procedure sauve_image_disque(image:p_imagedisk); forward;
//Conversions de formats d'images disques
function conversion_msa_vers_st(image_source:p_imagedisk; image_destination:p_imagedisk):boolean; forward;
function conversion_dim_vers_st(image_source:p_imagedisk; image_destination:p_imagedisk):boolean; forward;
function conversion_stt_vers_st(image_source:p_imagedisk; image_destination:p_imagedisk):boolean; forward;
function conversion_st_vers_msa(image_source:p_imagedisk; image_destination:p_imagedisk; msa_debut:integer; msa_fin:integer):boolean; forward;
//Conversion d'archives ZIP en image disque
function conversion_zip_vers_st(fichierzip:string; image:p_imagedisk):boolean; forward;
//Traitements divers des images disques
procedure stt_readsector(image:p_imagedisk;var buf_secteur:array of byte; numface:integer; numpiste:integer; numsecteur:integer); forward;
function lire_etat_cluster(entree_fat:integer; image:p_imagedisk) : integer;  forward;
procedure ecrire_etat_cluster(entree_fat:integer; valeur:integer; image:p_imagedisk);  forward;
procedure ecriture_fichier(fichier:p_entree_fat;var buffer:array of byte; image:p_imagedisk); forward;
procedure effacement_fichier(adr_entree_fat:integer; image:p_imagedisk); forward;
function comptage_clusters(type_cluster:integer; image:p_imagedisk):integer; forward;
function ecrire_entree_rep(cluster_rep:integer; niveau_rep:integer; fichier:p_entree_fat; verifier_nom:boolean; image:p_imagedisk):boolean; forward;
procedure creation_disquette_vierge(faces:integer; secteurs:smallint; pistes:smallint;
                                    taille_secteur:smallint; secteurs_par_cluster:smallint;
                                    entrees_rep_principal:smallint; secteurs_par_fat:byte;
                                    nomfichier:string);forward;
function extension_sous_repertoire(dernier_cluster:integer; image:p_imagedisk):integer; forward;
function creation_repertoire(nom_rep:string; niveau_rep_dest:integer; cluster_rep_dest:integer; image:p_imagedisk):integer; forward;
procedure effacement_repertoire(premier_cluster:integer; adr_entree_fat:integer; image:p_imagedisk); forward;
function transfert_fichier(fichier:p_entree_fat;var buffer:array of byte; cluster_rep_dest:integer; disquette:p_imagedisk):integer; forward;
procedure extraire_fichier(numero_entree:integer; image:p_imagedisk; var buffer:array of byte);
procedure lire_infos_image_disque(image:p_imagedisk;messages:boolean); forward;
//Divers
function mem_st_pc(donnee:word):word; forward;
procedure parametres_en_ligne; forward;


var
    rep_app:string;
    rep_utilisateur:string;
    rep_travail:string;
    stt_trackstart:array[1..2,0..85] of longword;
    format_nom_dest:integer;
    format_ext_dest:integer;
    format_nom_zip:integer;
    format_ext_zip:integer;

implementation

uses main, traduction, childwin, config, conversion, inifiles;

//-------------------------------------------------------------------------------------------
//Extraire le nom du fichier depuis le chemin d'accs complet rpertoire+fichier
function extraire_nom_fichier(nomfichier: String): String;
var
    x,max_x: smallint;

begin
    max_x:= Length(nomfichier);
    x:=max_x;
    while (x>=0) and (nomfichier[x]<>'\') do dec(x);

    if x<0 then result:=nomfichier
        else result:=rightstr(nomfichier,max_x-x);
end;

//-------------------------------------------------------------------------------------------
//Extraire le dbut nom du fichier sans extension depuis le chemin d'accs complet rpertoire+fichier
//caractres compris entre le dernier '\' et le premier '.'
function extraire_debut_nom_fichier(nomfichier: String): String;
var
    x,max_x: smallint;
    nom_fichtemp:string;

begin
    max_x:= Length(nomfichier);
    x:=max_x;
    while (x>=0) and (nomfichier[x]<>'\') do dec(x);

    if x<0 then nom_fichtemp:=nomfichier
        else nom_fichtemp:=rightstr(nomfichier,max_x-x);

    max_x := Length(nom_fichtemp);
    x:=0;
    while (x<=max_x) and (nom_fichtemp[x]<>'.') do
    begin
        inc(x);
    end;

    if x<0 then result:=nom_fichtemp
        else result:=leftstr(nom_fichtemp,x-1);
end;

//-------------------------------------------------------------------------------------------
//Extraire le nom du repertoire depuis le chemin d'accs complet rpertoire+fichier
function extraire_repertoire(nomfichier: String): String;
var
    x: smallint;

begin
    x:= Length(nomfichier);
    if nomfichier[x]='\' then result:=nomfichier
    else begin
        while (x>=0) and (nomfichier[x]<>'\') do dec(x);
        if x<0 then result:=nomfichier
        else result:=leftstr(nomfichier,x);
    end;

end;

//-------------------------------------------------------------------------------------------
//Extraire l'extension du fichier depuis le chemin d'accs complet rpertoire+fichier
function extraire_type_fichier(nomfichier: String): String;
var
    x,max_x:smallint;

begin
    max_x := Length(nomfichier);
    x:=max_x;
    while (x>=0) and (nomfichier[x]<>'.') and (nomfichier[x]<>'\') do dec(x);

    if (x<0) or (nomfichier[x]='\') then result:=''
        else result:=rightstr(nomfichier,max_x-x);
end;

//-------------------------------------------------------------------------------------------
//Cration du nom du fichier compress .ZIP
function nom_zip(nom_fichier_sour:string):string;
var
    nom_rep:string;
    nom_fichier:string;
    nomtemp:string;
    extension:string;
    x,max_x:smallint;
    chartemp:char;

begin
    nom_rep:=extraire_repertoire(nom_fichier_sour);
    nom_fichier:=extraire_nom_fichier(nom_fichier_sour);

    max_x := Length(nom_fichier);
    x:=max_x;
    while (x>=0) and (nom_fichier[x]<>'.') do dec(x);

    if x<0 then nomtemp:=nom_fichier
        else nomtemp:=leftstr(nom_fichier,x);

        //Mise en forme de la casse du nom
    if format_nom_zip=0 then
        nomtemp:=lowercase(nomtemp)
    else if format_nom_zip=1 then
    begin
        nomtemp:=lowercase(nomtemp);
        chartemp:=nomtemp[1];
        if (ord(chartemp)>=97) and (ord(chartemp)<=122) then chartemp:=chr(ord(chartemp)-32);
        nomtemp[1]:=chartemp;
    end else
        nomtemp:=uppercase(nomtemp);

    //Mise en forme de la casse de l'extension
    if format_ext_zip=0 then
        extension:='zip'
    else if format_ext_zip=1 then
        extension:='Zip'
    else
        extension:='ZIP';

    result:= nom_rep+ nomtemp + extension;
end;

//-------------------------------------------------------------------------------------------
//Chargement en mmoire d'une image disque
procedure charge_image_disque(image:p_imagedisk);
var
    ArchiveItem: TZFArchiveItem;
    taillefichier:integer;
    fichier1:tfilestream;
    nomzip:string;

begin
    With image^ do
    begin
        if lowercase(extraire_type_fichier(nomfichier))='zip' then
        begin
            if fileexists(nomfichier) then with msa_converter.zip do
            begin
                FileName :=nomfichier;
                OpenArchive(fmOpenRead);
                if (FindFirst('*.st',ArchiveItem,faAnyFile-faDirectory)) then
                begin
                    taillefichier:=ArchiveItem.UncompressedSize;
                    nomzip:=ArchiveItem.FileName;
                    setlength(donnees,taillefichier);
                    ExtractToBuffer(nomzip,donnees[0],taillefichier);
                    nomfichier:=nomzip;
                end else
                if (FindFirst('*.msa',ArchiveItem,faAnyFile-faDirectory)) then
                begin
                    taillefichier:=ArchiveItem.UncompressedSize;
                    nomzip:=ArchiveItem.FileName;
                    setlength(donnees,taillefichier);
                    ExtractToBuffer(nomzip,donnees[0],taillefichier);
                    nomfichier:=nomzip;
                end else
                if (FindFirst('*.dim',ArchiveItem,faAnyFile-faDirectory)) then
                begin
                    taillefichier:=ArchiveItem.UncompressedSize;
                    nomzip:=ArchiveItem.FileName;
                    setlength(donnees,taillefichier);
                    ExtractToBuffer(nomzip,donnees[0],taillefichier);
                    nomfichier:=nomzip;
                end else
                if (FindFirst('*.stt',ArchiveItem,faAnyFile-faDirectory)) then
                begin
                    taillefichier:=ArchiveItem.UncompressedSize;
                    nomzip:=ArchiveItem.FileName;
                    setlength(donnees,taillefichier);
                    ExtractToBuffer(nomzip,donnees[0],taillefichier);
                    nomfichier:=nomzip;
                end;
                CloseArchive;
            end;
        end else
        begin
            fichier1 := TFileStream.Create(nomfichier,fmOpenRead);
            taillefichier:=fichier1.Size;
            setlength(donnees,taillefichier);
            fichier1.read(donnees[0],taillefichier);
            fichier1.Free;
        end;
    end;
end;

//-------------------------------------------------------------------------------------------
//Sauvegarde une image disque
procedure sauve_image_disque(image:p_imagedisk);
var
    fichier:tfilestream;
    taille:integer;

begin
    taille:=length(image^.donnees);
    fichier := TFileStream.Create(image^.nomfichier,fmCreate);
    fichier.Seek(0,soFromBeginning);
    fichier.Write(image^.donnees[0],taille);
    fichier.free
end;

//-------------------------------------------------------------------------------------------
//Dcompresse une image disque MSA en mmoire
//Valeur renvoye:
//OK:True
//Pas OK:False
function conversion_msa_vers_st(image_source:p_imagedisk; image_destination:p_imagedisk):boolean;
var
    pointeursour:integer;
    pointeurdest:integer;
    i:smallint;
    compteur:smallint;
    taille_piste:smallint;
    nbdata:smallint;
    piste:smallint;
    face:smallint;
    temp:byte;
    buf:array of byte;
    taille_img_dest:integer;

begin
    //Saute l'entte du fichier
    pointeursour:=10;
    pointeurdest:=0;

    try
        with image_source^ do
        begin
            taille_img_dest:=(piste_fin-piste_depart+1)*nbfaces*nbsecteurs*taille_secteur;
            setlength(buf,taille_img_dest);

            for piste:= piste_depart to piste_fin do
            begin
                for face:=1 to nbfaces do
                begin
                    taille_piste:=donnees[pointeursour] shl 8;
                    inc(pointeursour);
                    inc(taille_piste,donnees[pointeursour]);
                    inc(pointeursour);

                    if taille_piste=taille_secteur*nbsecteurs then
                    begin
                        copymemory(@buf[pointeurdest],@donnees[pointeursour],taille_piste);
                        inc(pointeursour,taille_piste);
                        inc(pointeurdest,taille_piste);
                        if pointeurdest>taille_img_dest then abort;
                    end
                    else begin
                        compteur:=0;
                        while compteur<taille_secteur*nbsecteurs do
                        begin
                            temp:=donnees[pointeursour];
                            inc(pointeursour);
                            If temp <> $E5 Then
                            begin
                                buf[pointeurdest]:=temp;
                                inc(pointeurdest);
                                inc(compteur);
                                if pointeurdest>taille_img_dest then abort;
                            end
                            else begin
                                temp:=donnees[pointeursour];
                                inc(pointeursour);
                                nbdata:=donnees[pointeursour] shl 8;
                                inc(pointeursour);
                                inc(nbdata,donnees[pointeursour]);
                                inc(pointeursour);
                                for i:=1 to nbdata do
                                begin
                                    buf[pointeurdest]:= temp;
                                    inc(pointeurdest);
                                    if pointeurdest>taille_img_dest then abort;
                                end;
                                inc(compteur,nbdata);
                            end;
                        end;
                    end;
                end;
            end;
        end;
        setlength(image_destination^.donnees,pointeurdest);
        copymemory(@image_destination.donnees[0],@buf[0],pointeurdest);
        result:=true;
    except
        result:=false;
    end;

    setlength(buf,0);
end;

//-------------------------------------------------------------------------------------------
//Conversion d'une image disque DIM vers ST en mmoire
//Valeur renvoye:
//OK:True
//Pas OK:False
function conversion_dim_vers_st(image_source:p_imagedisk; image_destination:p_imagedisk):boolean;
var
    taille:integer;
begin
    try
        taille:=length(image_source.donnees)-32;
        setlength(image_destination^.donnees,taille);
        copymemory(@image_destination.donnees[0],@image_source.donnees[32],taille);
        result:=true;
    except
        result:=false
    end;
end;

//-------------------------------------------------------------------------------------------
//Conversion d'une image disque STT vers ST en mmoire
//Valeur renvoye:
//OK:True
//Pas OK:False
function conversion_stt_vers_st(image_source:p_imagedisk; image_destination:p_imagedisk):boolean;
var
    num_piste:integer;
    num_face:integer;
    pointeursour:integer;
    pointeurdest:integer;
    buf:array of byte;
    buf_secteur:array of byte;
    compteur:integer;
    secteur_nombre:integer;
    i:integer;
    boot_nbsecteurs:integer;
    boot_nbfaces:integer;
    boot_nbpistes:integer;
    choix:word;
    nombre_pistes_utilise:integer;
    nombre_faces_utilise:integer;
    nombre_secteurs_utilise:integer;

begin
    try
        with image_source^ do
        begin
            setlength(buf,(piste_fin-piste_depart+1)*nbfaces*nbsecteurs*taille_secteur);
            setlength(buf_secteur,taille_secteur);

            nombre_pistes_utilise:=piste_fin;
            nombre_faces_utilise:=nbfaces;
            nombre_secteurs_utilise:=nbsecteurs;

            //Lecture des adresses de dbut des pistes
            pointeursour:= 14;
            for num_face:=1 to nbfaces do
                for num_piste:=0 to piste_fin do
                begin
                    stt_trackstart[num_face,num_piste]:=donnees[pointeursour];
                    inc(pointeursour);
                    stt_trackstart[num_face,num_piste]:=stt_trackstart[num_face,num_piste]+ donnees[pointeursour] shl 8;
                    inc(pointeursour);
                    stt_trackstart[num_face,num_piste]:=stt_trackstart[num_face,num_piste]+ donnees[pointeursour] shl 16;
                    inc(pointeursour);
                    stt_trackstart[num_face,num_piste]:=stt_trackstart[num_face,num_piste]+ donnees[pointeursour] shl 24;
                    inc(pointeursour,3);
                end;

            //Lecture des infos du bootsecteur
            stt_readsector(image_source,buf_secteur,1,0,1);
            boot_nbfaces:=buf_secteur[26];
            boot_nbfaces:=boot_nbfaces+buf_secteur[27] shl 8;
            boot_nbsecteurs:=buf_secteur[24];
            boot_nbsecteurs:=boot_nbsecteurs+buf_secteur[25] shl 8;
            boot_nbpistes:=buf_secteur[19];
            boot_nbpistes:=boot_nbpistes+buf_secteur[20] shl 8;
            if (boot_nbfaces<>0) and (boot_nbsecteurs<>0) then boot_nbpistes:=boot_nbpistes div (boot_nbfaces*boot_nbsecteurs);

            if (boot_nbfaces<>nbfaces) or (boot_nbsecteurs<>nbsecteurs) or (boot_nbpistes<>piste_fin+1) then
            begin
                choix:=MessageDlg(nomfichier
                    +#13#10+#13#10+textes_general[112]
                    +#13#10+#13#10+textes_general[113]
                    +#13#10+'       '+textes_general[114]+inttostr(boot_nbfaces)
                    +#13#10+'       '+textes_general[115]+inttostr(boot_nbsecteurs)
                    +#13#10+'       '+textes_general[116]+inttostr(boot_nbpistes)
                    +#13#10+#13#10+'STT :'
                    +#13#10+'       '+textes_general[114]+inttostr(nbfaces)
                    +#13#10+'       '+textes_general[115]+inttostr(nbsecteurs)
                    +#13#10+'       '+textes_general[116]+inttostr(piste_fin+1)
                    +#13#10+#13#10+textes_general[117]
                    , mtConfirmation, [mbYes, mbNo], 0);

                case choix of
                    mrYes:
                        begin
                            nombre_pistes_utilise:=boot_nbpistes-1;
                            nombre_faces_utilise:=boot_nbfaces;
                            nombre_secteurs_utilise:=boot_nbsecteurs;
                        end;
                    mrNo:
                end;
            end;

            //Lecture des secteurs
            pointeurdest:=0;
            for num_piste:= 0 to nombre_pistes_utilise do
            begin
                for num_face:= 1 To nombre_faces_utilise do
                begin
                    pointeursour:=stt_trackstart[num_face,num_piste]+10;
                    secteur_nombre:=donnees[pointeursour];
                    inc(pointeursour);
                    secteur_nombre:=secteur_nombre+donnees[pointeursour] shl 8;
                    if secteur_nombre>nombre_secteurs_utilise then secteur_nombre:=nombre_secteurs_utilise;
                    if secteur_nombre>0 then
                    begin
                        for compteur:=1 to secteur_nombre do
                        begin

                            pointeurdest:=num_piste*nombre_faces_utilise*nombre_secteurs_utilise*taille_secteur;
                            pointeurdest:=pointeurdest+(compteur-1)*taille_secteur;
                            pointeurdest:=pointeurdest+(num_face-1)*nombre_secteurs_utilise*taille_secteur;

                            stt_readsector(image_source,buf_secteur,num_face,num_piste,compteur);
                            copymemory(@buf[pointeurdest],buf_secteur,taille_secteur);
                            inc(pointeurdest,taille_secteur);
                        end;
                    end
                    else begin
                        for compteur:=1 to nombre_secteurs_utilise do
                        begin
                            for i:=1 to taille_secteur do
                            begin
                                buf[pointeurdest]:=0;
                                inc(pointeurdest);
                            end;
                        end;
                    end;
                end;
            end;
        end;
        setlength(image_destination^.donnees,pointeurdest);
        copymemory(@image_destination.donnees[0],@buf[0],pointeurdest);
        result:=true
    except
        result:=false;
    end;
    setlength(buf,0);
end;

//-------------------------------------------------------------------------------------------
//Compresse une image disque en MSA en mmoire
//Valeur renvoye:
//OK:True
//Pas OK:False
function conversion_st_vers_msa(image_source:p_imagedisk; image_destination:p_imagedisk; msa_debut:integer; msa_fin:integer):boolean;
var
    pointeursour:integer;
    pointeursour1:integer;
    pointeurdest:integer;
    taille_buf:integer;
    pointeurpiste:smallint;
    valeur:byte;
    i:smallint;
    compteur_rle:smallint;
    compteur_donnees:smallint;
    taille_piste_st:smallint;
    piste:smallint;
    face:smallint;
    buf:array of byte;
    pistebuf:array of byte;

begin
    try
        with image_source^ do
        begin
            pointeursour:= taille_secteur*nbsecteurs*msa_debut*nbfaces;
            pointeurdest:= 0;
            //Taille maxi d'une piste standard sur une face
            taille_piste_st:=taille_secteur*nbsecteurs;

            taille_buf:=taille+(msa_fin - msa_debut+1)*nbfaces*2+10;
            //+(msa_fin - msa_debut+1)*nbfaces*2 -> au cas o toutes les pistes sont incompressibles
            // il faut prvoir la place pour chacune pour le mot indicant la taille des donnes
            //+10 pour l'entte de fichier
            setlength(buf,taille_buf);
            setlength(pistebuf,nbsecteurs*taille_secteur*2);
            //*2 au cas o la piste est incompressible et donc plus grosse que l'originale

            buf[pointeurdest]:=$0E;
            inc(pointeurdest);
            buf[pointeurdest]:=$0F;
            inc(pointeurdest);
            buf[pointeurdest]:=hi(nbsecteurs);
            inc(pointeurdest);
            buf[pointeurdest]:=lo(nbsecteurs);
            inc(pointeurdest);
            buf[pointeurdest]:=hi(nbfaces - 1);
            inc(pointeurdest);
            buf[pointeurdest]:=lo(nbfaces - 1);
            inc(pointeurdest);
            buf[pointeurdest]:=hi(msa_debut);
            inc(pointeurdest);
            buf[pointeurdest]:=lo(msa_debut);
            inc(pointeurdest);
            buf[pointeurdest]:=hi(msa_fin);
            inc(pointeurdest);
            buf[pointeurdest]:=lo(msa_fin);
            inc(pointeurdest);

            for piste:= 0 to (msa_fin - msa_debut) do
            begin
                for face:= 1 To nbfaces do
                begin
                    compteur_donnees:=taille_piste_st;
                    pointeurpiste:=0;
                    pointeursour1:=pointeursour;
                    while (compteur_donnees>0) do
                    begin
                        compteur_rle:=0;
                        valeur:=donnees[pointeursour];
                        if compteur_donnees>3 then
                        begin
                            i:=0;
                            while (donnees[pointeursour+i]=valeur) and (i<compteur_donnees) do
                            begin
                                inc(compteur_rle);
                                inc(i);
                            end;
                        end;

                        If compteur_rle=0 Then compteur_rle:= 1;

                        If compteur_rle>3 then
                        begin
                            pistebuf[pointeurpiste]:=$E5;
                            inc(pointeurpiste);
                            pistebuf[pointeurpiste]:=valeur;
                            inc(pointeurpiste);
                            pistebuf[pointeurpiste]:=hi(compteur_rle);
                            inc(pointeurpiste);
                            pistebuf[pointeurpiste]:=lo(compteur_rle);
                            inc(pointeurpiste);
                            inc(pointeursour,compteur_rle);
                            dec(compteur_donnees,compteur_rle);
                        end
                        else begin
                            if valeur = $E5 then
                            begin
                                pistebuf[pointeurpiste]:=$E5;
                                inc(pointeurpiste);
                                pistebuf[pointeurpiste]:=valeur;
                                inc(pointeurpiste);
                                pistebuf[pointeurpiste]:=hi(compteur_rle);
                                inc(pointeurpiste);
                                pistebuf[pointeurpiste]:=lo(compteur_rle);
                                inc(pointeurpiste);
                                inc(pointeursour,compteur_rle);
                                dec(compteur_donnees,compteur_rle);
                            end
                            else begin
                                for i:=1 to compteur_rle do
                                begin
                                    pistebuf[pointeurpiste]:=valeur;
                                    inc(pointeurpiste);
                                end;
                                inc(pointeursour,compteur_rle);
                                dec(compteur_donnees,compteur_rle);
                            end;
                        end;
                    end;

                    if pointeurpiste>=taille_piste_st then
                    begin
                        buf[pointeurdest]:=hi(taille_piste_st);
                        inc(pointeurdest);
                        buf[pointeurdest]:=lo(taille_piste_st);
                        inc(pointeurdest);
                        copymemory(@buf[pointeurdest],@donnees[pointeursour1],taille_piste_st);
                        inc(pointeurdest,taille_piste_st);
                    end
                    else begin
                        buf[pointeurdest]:=hi(pointeurpiste);
                        inc(pointeurdest);
                        buf[pointeurdest]:=lo(pointeurpiste);
                        inc(pointeurdest);
                        copymemory(@buf[pointeurdest],@pistebuf[0],pointeurpiste);
                        inc(pointeurdest,pointeurpiste);
                    end;
                end;
            end;
        end;

        setlength(image_destination^.donnees,pointeurdest);
        copymemory(@image_destination.donnees[0],@buf[0],pointeurdest);
        result:=true
    except
        result:=false;
    end;
    setlength(buf,0);
    setlength(pistebuf,0);
end;

//-------------------------------------------------------------------------------------------
//Conversion du contenu d'une archive Zip vers une image disque ST
//Valeur renvoye:
//OK:True
//Pas OK:False
function conversion_zip_vers_st(fichierzip:string; image:p_imagedisk):boolean;
var
    ArchiveItem: TZFArchiveItem;
    ListItem:TListItem;
    taille_totale:integer;
    taille_calcul:integer;
    calcul:integer;
    taille_sur_disque:integer;

    secteurs:integer;
    faces:integer;
    pistes:integer;
    autor_transfert:boolean;

    tab_repertoires:array of entree_fat;
    tab_nomrep:array of string;
    nb_repertoires:integer;
    nb_fichiers:integer;
    compteur_fich:integer;
    compteur_rep:integer;
    nom_rep:string;
    nom_fichier:string;
    nom_disquette:string;
    type_fichier:string;
    nouveau_repertoire:boolean;
    imgdisk_dans_zip:boolean;
    choix:integer;

    niveau_rep_dest:integer;
    cluster_rep_dest:integer;
    temp:string;
    temp_rep:string;
    chemin_rep:string;
    x:integer;

    buffer_fichier:array of byte;
    taille_fichier:integer;
    fichier:entree_fat;
    resultat_transfert:integer;
    heure_date_temp:tdatetime;

begin
    resultat_transfert:=0;
    autor_transfert:=true;
    if fileexists(fichierzip) then with msa_converter.zip do
    begin
        FileName :=fichierzip;
        msa_converter.liste_transfert.Items.Clear;
        taille_totale:=0;
        imgdisk_dans_zip:=false;

        //Remplissage listview
        OpenArchive(fmOpenRead);
        if (FindFirst('*.*',ArchiveItem,faAnyFile-faDirectory)) then
        repeat
           	ListItem:=msa_converter.liste_transfert.Items.Add;
        	ListItem.Caption:=ArchiveItem.FileName;
            type_fichier:=lowercase(extraire_type_fichier(ArchiveItem.FileName));
            if (type_fichier='st') or(type_fichier='msa') or (type_fichier='stt')
                or (type_fichier='dim') then imgdisk_dans_zip:=true;
        	ListItem.SubItems.Add(IntToStr(ArchiveItem.UncompressedSize));
        	ListItem.SubItems.Add(ArchiveItem.StoredPath);
            try
                heure_date_temp:=FileDateToDateTime(ArchiveItem.LastModFileDate shl 16+ArchiveItem.LastModFileTime);
            except
                heure_date_temp:=now;
            end;
        	ListItem.SubItems.Add(timetostr(heure_date_temp));
        	ListItem.SubItems.Add(datetostr(heure_date_temp));

            taille_fichier:=ArchiveItem.UncompressedSize;
            calcul:=taille_fichier div 1024;  //1024=taille d'un cluster
            if (calcul*1024<taille_fichier) then inc(calcul);
            taille_sur_disque:=calcul*1024;
            inc(taille_totale,taille_sur_disque);
        until (not FindNext(ArchiveItem));

        //Demande si on continue si prsence fichier ST, MSA, STT ou DIM dans ZIP
        if imgdisk_dans_zip=true then
        begin
            choix:=MessageDlg(fichierzip+#13#10+#13#10+textes_general[127], mtConfirmation, [mbYes, mbNo], 0);
            if choix=mrNo then
            begin
                autor_transfert:=false;
                resultat_transfert:=2;
            end;
        end;

        //Dtermination de la taille de l'image disque destination
        faces:=1;
        pistes:=80;
        secteurs:=9;
        taille_calcul:=trunc(taille_totale*1.05);
        if autor_transfert=true then
        begin
            repeat
                calcul:=faces*pistes*secteurs*512;
                if calcul<=taille_calcul then inc(pistes);
                if pistes>=83 then
                begin
                    pistes:=80;
                    inc(secteurs);
                end;
                if (secteurs>=12) and (faces<2)  then
                begin
                    secteurs:=9;
                    inc(faces);
                end;
                if faces>=3 then autor_transfert:=false;
                if secteurs>=19 then autor_transfert:=false;
            until (calcul>taille_calcul) or (autor_transfert=false);
        end;

        if autor_transfert=true then
        begin
            //Cration disquette vierge et chargement en mmoire
            nom_disquette:=image.nomfichier;
            creation_disquette_vierge(faces,secteurs,pistes,512,2,112,5,nom_disquette);
            image.nomfichier:=nom_disquette;
            charge_image_disque(image);
            lire_infos_image_disque(image,true);

            with msa_converter.liste_transfert do
            begin
                //Cration de l'arborescence des rpertoires
                setlength(tab_repertoires,0);
                nb_repertoires:=0;
                nb_fichiers:=Items.Count;
                for compteur_fich:=0 to nb_fichiers-1 do
                begin
                    nom_rep:=Items[compteur_fich].SubItems[1];
                    if nom_rep<>'' then
                    begin
                        niveau_rep_dest:=-1;
                        temp_rep:=nom_rep;
                        cluster_rep_dest:=0;
                        chemin_rep:='';
                        repeat
                            //Extrait le nom du premier rpertoire du chemin
                            x:=pos('\',temp_rep);
                            if x<>0 then
                            begin
                                temp:=leftstr(temp_rep,x-1);
                                temp_rep:=rightstr(temp_rep,length(temp_rep)-x);

                                if chemin_rep<>'' then chemin_rep:=chemin_rep+'\'+temp
                                    else chemin_rep:=temp;
                                //Contrle si le rpertoire existe dj
                                inc(niveau_rep_dest);
                                nouveau_repertoire:=true;
                                if nb_repertoires>0 then
                                    for compteur_rep:=0 to nb_repertoires-1 do
                                        if (tab_repertoires[compteur_rep].nom=temp) and (chemin_rep=tab_nomrep[compteur_rep]) then
                                        begin
                                            nouveau_repertoire:=false;
                                            cluster_rep_dest:=tab_repertoires[compteur_rep].premier_cluster;
                                        end;

                                //Cration du nouveau rpertoire
                                if nouveau_repertoire=true then
                                begin
                                    inc(nb_repertoires);
                                    setlength(tab_repertoires,nb_repertoires);
                                    setlength(tab_nomrep,nb_repertoires);
                                    tab_repertoires[nb_repertoires-1].nom:=temp;
                                    tab_repertoires[nb_repertoires-1].premier_cluster:=creation_repertoire(temp,niveau_rep_dest,cluster_rep_dest,image);
                                    tab_nomrep[nb_repertoires-1]:=chemin_rep;
                                    cluster_rep_dest:=tab_repertoires[nb_repertoires-1].premier_cluster;
                                end;
                            end else temp:=temp_rep;
                        until x=0;
                    end;
                end;

                //Transfert des fichiers
                compteur_fich:=0;
                repeat
                    nom_rep:=Items[compteur_fich].SubItems[1];
                    nom_fichier:=Items[compteur_fich].SubItems[1]+Items[compteur_fich].Caption;
                    taille_fichier:=strtoint(Items[compteur_fich].SubItems[0]);
                    setlength(buffer_fichier,taille_fichier);
                    ExtractToBuffer(nom_fichier,buffer_fichier[0],taille_fichier);
                    fichier.nom:=Items[compteur_fich].Caption;
                    fichier.taille:=taille_fichier;
                    fichier.heure:=Items[compteur_fich].SubItems[2];
                    fichier.date:=Items[compteur_fich].SubItems[3];
                    cluster_rep_dest:=0;
                    if nom_rep<>'' then for compteur_rep:=0 to nb_repertoires-1 do
                            if(nom_rep=tab_nomrep[compteur_rep]+'\') then cluster_rep_dest:=tab_repertoires[compteur_rep].premier_cluster;
                    resultat_transfert:=transfert_fichier(@fichier,buffer_fichier,cluster_rep_dest,image);
                    inc(compteur_fich);
                until (compteur_fich>=nb_fichiers) or (resultat_transfert=0)
            end;

            setlength(tab_repertoires,0);
            setlength(tab_nomrep,0);
            setlength(buffer_fichier,0);
        end;
        CloseArchive;
    end;
    if resultat_transfert=0 then MessageDlg(textes_general[122], mtInformation, [mbOk], 0);
    if (resultat_transfert<>1) or (autor_transfert=false) then result:=false else result:=true;
end;

//-------------------------------------------------------------------------------------------
//Lecture d'un secteur dans une image disque *.STT
procedure stt_readsector(image:p_imagedisk; var buf_secteur:array of byte; numface:integer; numpiste:integer; numsecteur:integer);
var
    pointeursour:integer;
    pointeurdest:integer;

    secteur_numero:byte;
    secteur_offset:integer;
    secteur_longueur:integer;
    cherche_secteur:integer;
    i:integer;

begin
    with image^ do
    begin
        //Recherche le secteur demand
        pointeursour:=stt_trackstart[numface,numpiste]+4;
        pointeurdest:=0;
        cherche_secteur:=0;
        repeat
            inc(cherche_secteur);
            inc(pointeursour,10);
            secteur_numero:=donnees[pointeursour];
        until (cherche_secteur>=nbsecteurs) or (secteur_numero=numsecteur);
        secteur_offset:=0;
        secteur_longueur:=0;

        //Recherche des donnes du secteur
        if secteur_numero=numsecteur then
        begin
            inc(pointeursour,4);
            secteur_offset:=donnees[pointeursour];
            inc(pointeursour);
            secteur_offset:=secteur_offset+donnees[pointeursour] shl 8;
            inc(pointeursour);
            secteur_longueur:=donnees[pointeursour];
            inc(pointeursour);
            secteur_longueur:=secteur_longueur+donnees[pointeursour] shl 8;
        end;

        //Copie des donnes du secteur
        copymemory(@buf_secteur[pointeurdest],@donnees[stt_trackstart[numface,numpiste]+secteur_offset],secteur_longueur);
        inc(pointeurdest,secteur_longueur);

        //Complte la taille des secteurs vides ou incomplets
        if secteur_longueur<taille_secteur then
            for i:=secteur_longueur to taille_secteur-1 do
            begin
                buf_secteur[pointeurdest]:=0;
                inc(pointeurdest);
            end;
    end;
end;

//-------------------------------------------------------------------------------------------
//Lecture de l'tat d'un cluster dans la premire FAT
function lire_etat_cluster(entree_fat:integer; image:p_imagedisk) : integer;
var
    adr:integer;
    num:integer;
    calcul:integer;

begin
    if odd(entree_fat)=false then  //entre FAT paire
    begin
        adr:=image^.taille_secteur+((3*entree_fat) shr 1);
        num:=image^.donnees[adr];
        calcul:=image^.donnees[adr+1] and $f;
        calcul:=calcul shl 8;
        inc(num,calcul);
    end
    else begin  //entre FAT impaire
        adr:=image^.taille_secteur+((3*(entree_fat-1)) shr 1)+1;
        calcul:=image^.donnees[adr] and $f0;
        calcul:=calcul shr 4;
        num:=image^.donnees[adr+1] shl 4;
        inc(num,calcul);
    end;
    result:=num;
end;

//-------------------------------------------------------------------------------------------
//Ecriture de l'tat d'un cluster dans les deux FATS
procedure ecrire_etat_cluster(entree_fat:integer; valeur:integer; image:p_imagedisk);
var
    data1:byte;
    data2:byte;
    adr:integer;

begin
    if odd(entree_fat)=false then  //entre FAT paire
    begin
        data1:=valeur and $ff;
        data2:=(valeur and $f00) shr 8;
        //Ecriture dans la premire FAT
        adr:=image^.taille_secteur+((3*entree_fat) shr 1);
        image^.donnees[adr]:=data1;
        image^.donnees[adr+1]:=(image^.donnees[adr+1] and $f0) or data2;

        if image^.nbfats=2 then
        begin
            //Ecriture dans la deuxime FAT
            inc(adr,image^.secteurs_par_fat*image^.taille_secteur);
            image^.donnees[adr]:=data1;
            image^.donnees[adr+1]:=(image^.donnees[adr+1] and $f0) or data2;
        end;
    end
    else begin  //entre FAT impaire
        data1:=(valeur and $f) shl 4;
        data2:=(valeur and $ff0) shr 4;
        //Ecriture dans la premire FAT
        adr:=image^.taille_secteur+((3*(entree_fat-1)) shr 1)+1;
        image^.donnees[adr]:=(image^.donnees[adr] and $0f) or data1;
        image^.donnees[adr+1]:=data2;

        if image^.nbfats=2 then
        begin
            //Ecriture dans la deuxime FAT
            inc(adr,image^.secteurs_par_fat*image^.taille_secteur);
            image^.donnees[adr]:=(image^.donnees[adr] and $0f) or data1;
            image^.donnees[adr+1]:=data2;
        end;
    end;
end;

//-------------------------------------------------------------------------------------------
//Ecriture d'un fichier sur une image disque .ST
procedure ecriture_fichier(fichier:p_entree_fat;var buffer:array of byte; image:p_imagedisk);
var
    pointeur_sour:integer;
    pointeur_dest:integer;
    num_cluster:integer;
    cluster_temp:integer;
    octets_restants:integer;
    taille_cluster:integer;
    taille_fichier:integer;
    nb_octets_a_copier:integer;
    compteur:integer;

begin
    taille_cluster:=image^.taille_cluster;
    taille_fichier:=fichier^.taille;
    octets_restants:=taille_fichier;
    num_cluster:=fichier^.premier_cluster;
    pointeur_sour:=0;
    pointeur_dest:=(num_cluster-2)*taille_cluster;
    pointeur_dest:=pointeur_dest+image^.adr_debut_rep+(image^.entrees_rep_principal shl 5);

    repeat
        if octets_restants>taille_cluster then
        begin
            nb_octets_a_copier:=taille_cluster;
            copymemory(@image.donnees[pointeur_dest],@buffer[pointeur_sour],nb_octets_a_copier);

            cluster_temp:=num_cluster;
            repeat
                inc(num_cluster);
            until (lire_etat_cluster(num_cluster,image)=0);
            ecrire_etat_cluster(cluster_temp,num_cluster,image);
            pointeur_dest:=(num_cluster-2)*taille_cluster;
            pointeur_dest:=pointeur_dest+image^.adr_debut_rep+(image^.entrees_rep_principal shl 5);
        end
        else begin
            nb_octets_a_copier:=octets_restants;
            copymemory(@image.donnees[pointeur_dest],@buffer[pointeur_sour],nb_octets_a_copier);
            for compteur:=octets_restants to image^.taille_cluster do image^.donnees[pointeur_dest+compteur]:=0;
            ecrire_etat_cluster(num_cluster,$FFF,image);
        end;

        dec(octets_restants,nb_octets_a_copier);
        inc(pointeur_sour,nb_octets_a_copier);
    until octets_restants<=0;

end;

//-------------------------------------------------------------------------------------------
//Effacement d'un fichier dans une image disque
procedure effacement_fichier(adr_entree_fat:integer; image:p_imagedisk);
var
    cluster_suivant:integer;
    cluster_temp:integer;

begin
    cluster_suivant:=image^.donnees[adr_entree_fat+26];
    cluster_suivant:=cluster_suivant+(image^.donnees[adr_entree_fat+27] shl 8);

    repeat
        cluster_temp:=cluster_suivant;
        cluster_suivant:=lire_etat_cluster(cluster_suivant,image);
        ecrire_etat_cluster(cluster_temp,0,image);
        image^.donnees[adr_entree_fat]:=$e5;
    until (cluster_suivant>4080) or (cluster_suivant<2);
end;

//-------------------------------------------------------------------------------------------
//Comptage des clusters d'une image disque ST selon leur type
//(1:libre, 2:utilis, 3:rserv, 4:mauvais, 5:systme, 6:tous)
function comptage_clusters(type_cluster:integer; image:p_imagedisk):integer;
var
    nombre_clusters:integer;
    info_cluster:integer;
    numero_cluster:integer;
    calc:integer;
    compteur:integer;

begin
    compteur:=0;

    with image^ do
    begin
        calc:=entrees_rep_principal shr 4;      // Rpertoire principal
        inc(calc);                              // Bootsecteur
        inc(calc,nbfats*secteurs_par_fat);      // Les deux FATs
        if odd(calc) then inc(calc);            // Nombre toujours pair
        calc:=calc div secteurs_par_cluster;
        nombre_clusters:=(nbsecteurs*nbfaces*(piste_fin-(piste_depart-1))) div secteurs_par_cluster;

        if type_cluster=6 then
            compteur:=nombre_clusters
        else begin
            dec(nombre_clusters,calc);              //Rpertoire principal + FATs (voir ci-dessus)

            if type_cluster=5 then
                compteur:=calc+2     //2 premires entres FAT inutilises
            else begin
                dec(nombre_clusters);                   //Comptage  partir de 0
                for numero_cluster:=2 to nombre_clusters do     //2 premires entres FAT inutilises
                begin
                    info_cluster:=lire_etat_cluster(numero_cluster,image);
                    case type_cluster of
                        1: if info_cluster=$000 then inc(compteur);
                        2:  begin
                                if (info_cluster>=$001) and (info_cluster<=$fef) then inc(compteur);
                                if (info_cluster>=$ff8) and (info_cluster<=$fff) then inc(compteur);
                            end;
                        3: if (info_cluster>=$ff0) and (info_cluster<=$ff6) then inc(compteur);
                        4: if info_cluster=$ff7 then inc(compteur);
                    end;
                end;
            end;
        end;
        result:=compteur;
    end;
end;

//-------------------------------------------------------------------------------------------
//Ecriture d'une entre dans un rpertoire
function ecrire_entree_rep(cluster_rep:integer; niveau_rep:integer; fichier:p_entree_fat; verifier_nom:boolean; image:p_imagedisk):boolean;
const
    caracteres=[' ','.'];  //Caractres interdits

var
    compteur:integer;
    pointeur:integer;
    pointeur_rep:integer;
    index_rep:integer;
    cluster_temp:integer;
    choix_remplacer:integer;
    nomtemp:string;
    debut_nom:string;
    extension:string;
    controle_nom:string;
    nom_valide:boolean;
    controle_doublon_termine:boolean;
    annulation:boolean;
    nom_deja_utilise:boolean;
    taille:integer;
    lettre:char;
    data:byte;

    heure_pos:integer;
    heure_heures:integer;
    heure_minutes:integer;
    heure_secondes:integer;
    date_jour:integer;
    date_mois:integer;
    date_annee:integer;
    date_heure_temp:integer;

begin
    pointeur:=fichier^.adresse_declaration;
    index_rep:=0;
    annulation:=false;

    //Contrle de la validit du nom du fichier
    nomtemp:=fichier^.nom;
    if verifier_nom=true then
    begin
        repeat
            if niveau_rep=0 then pointeur_rep:=image^.adr_debut_rep
            else begin
                pointeur_rep:=(cluster_rep-2)*image^.taille_cluster;
                pointeur_rep:=pointeur_rep+image^.adr_debut_rep+(image^.entrees_rep_principal shl 5);
            end;

            nom_valide:=true;
            nom_deja_utilise:=false;

            //Teste le dbut du nom (avant le point)
            debut_nom:='';
            if length(nomtemp)>0 then debut_nom:=extraire_debut_nom_fichier(nomtemp);
            taille:=length(debut_nom);
            if (taille<9) and (taille>0) then
            begin
                for compteur:=1 to taille do
                begin
                    lettre:=debut_nom[compteur];
                    if lettre in ['a'..'z'] then debut_nom[compteur]:=upcase(lettre)
                        else if lettre in caracteres then nom_valide:=false;
                end;
            end
            else nom_valide:=false;

            //Complte le dbut du nom pour arriver  8 caractres
            if (nom_valide=true) and (taille<8) then
                for compteur:=taille+1 to 8 do
                begin
                 debut_nom:=debut_nom+' ';
                end;

            //Teste l'extension du nom (aprs le point)
            extension:='';
            if length(nomtemp)>0 then extension:=extraire_type_fichier(nomtemp);
            taille:=length(extension);
            if taille<4 then
            begin
                for compteur:=1 to taille do
                begin
                    lettre:=extension[compteur];
                    if lettre in ['a'..'z'] then extension[compteur]:=upcase(lettre)
                    else if lettre in caracteres then nom_valide:=false;
                end;
            end
            else nom_valide:=false;

            //Complte l'extension pour arriver  3 caractres
            //et cration du nom complet (dbut+extension)
            if (nom_valide=true) then
            begin
                if taille <3 then
                    for compteur:=taille+1 to 3 do extension:=extension+' ';

                //Vrification que le nom de fichier n'est pas dj utilis
                nomtemp:=debut_nom+extension;
                index_rep:=0;
                controle_doublon_termine:=false;
                cluster_temp:=cluster_rep;
                repeat
                    controle_nom:='';
                    for compteur:=0 to 10 do
                    begin
                        data:=image^.donnees[pointeur_rep+index_rep+compteur];
                        controle_nom:=controle_nom+char(data);
                    end;

                    if nomtemp=controle_nom then
                    begin
                        data:=image^.donnees[pointeur_rep+index_rep+11] and $10;
                        if data=(fichier^.attributs and $10) then
                        begin
                            nom_deja_utilise:=true;
                            nom_valide:=false;
                            controle_doublon_termine:=true;
                        end;
                    end;

                    if nom_valide=true then
                    begin
                        inc(index_rep,32);
                        if (niveau_rep=0) and (index_rep>=(image^.entrees_rep_principal shl 5)) then
                            controle_doublon_termine:=true;
                        if (niveau_rep>0) and (index_rep>=image^.taille_cluster) then
                        begin
                            if lire_etat_cluster(cluster_temp,image)=$FFF then
                                controle_doublon_termine:=true
                            else begin
                                cluster_temp:=lire_etat_cluster(cluster_temp,image);
                                pointeur_rep:=(cluster_temp-2)*image^.taille_cluster;
                                pointeur_rep:=pointeur_rep+image^.adr_debut_rep+(image^.entrees_rep_principal shl 5);
                                index_rep:=0;
                            end;
                        end;
                    end;
                until controle_doublon_termine=true;
            end;

            if nom_valide=false then
            begin
                //Demande si remplacement d'un fichier dj existant ayant le mme nom
                if (nom_deja_utilise=true) and (fichier^.attributs<>$10) then
                begin
                    choix_remplacer:=MessageDlg(textes_general[123] +debut_nom+'.'+extension, mtConfirmation, [mbYes, mbNo], 0);
                    case choix_remplacer of
                    mrYes:
                        begin
                            effacement_fichier(pointeur_rep+index_rep,image);
                            nom_valide:=true;
                        end;
                    mrNo:
                        annulation:=true;
                    end;
                end
                else begin
                    nomtemp:='';
                    annulation:=not(InputQuery(textes_general[118],textes_general[119]+debut_nom+'.'+extension,nomtemp));
                end;
            end;
        until (nom_valide=true) or (annulation=true);
    end;

    if annulation=false then
    begin
        //Ecriture du nom du fichier
        for compteur:=0 to 10 do
        begin
            image^.donnees[pointeur+compteur]:=byte(nomtemp[compteur+1]);
        end;
        inc(pointeur,11);

        //Ecriture des attributs du fichier
        image^.donnees[pointeur]:=fichier^.attributs;
        inc(pointeur);

        //Ecriture de l'espace rserv
        for compteur:=0 to 9 do
        begin
            image^.donnees[pointeur+compteur]:=0;
        end;
        inc(pointeur,10);

        //Ecriture de l'heure de la dernire modification du fichier
        heure_heures:=strtoint(midstr((fichier.heure),1,1));
        heure_minutes:=strtoint(midstr((fichier.heure),4,2));
        heure_secondes:=strtoint(midstr((fichier.heure),7,2));
        date_heure_temp:=heure_heures shl 11;
        date_heure_temp:=date_heure_temp+(heure_minutes shl 5);
        date_heure_temp:=date_heure_temp+(heure_secondes shr 1);

        image^.donnees[pointeur]:=lo(date_heure_temp);
        image^.donnees[pointeur+1]:=hi(date_heure_temp);
        inc(pointeur,2);

        //Ecriture de la date de la dernire modification du fichier
        date_jour:=strtoint(leftstr((fichier.date),2));
        date_mois:=strtoint(midstr((fichier.date),4,2));
        date_annee:=strtoint(rightstr((fichier.date),4));
        date_heure_temp:=(date_annee-1980) shl 9;
        date_heure_temp:=date_heure_temp+(date_mois shl 5);
        date_heure_temp:=date_heure_temp+date_jour;

        image^.donnees[pointeur]:=lo(date_heure_temp);
        image^.donnees[pointeur+1]:=hi(date_heure_temp);
        inc(pointeur,2);

        //Ecriture du premier cluster des donnes du fichier
        image^.donnees[pointeur]:=lo(fichier^.premier_cluster);
        image^.donnees[pointeur+1]:=hi(fichier^.premier_cluster);
        inc(pointeur,2);

        //Ecriture de la taille du fichier
        image^.donnees[pointeur]:=(fichier^.taille and $000000FF);
        image^.donnees[pointeur+1]:=(fichier^.taille and $0000FF00) shr 8;
        image^.donnees[pointeur+2]:=(fichier^.taille and $00FF0000) shr 16;
        image^.donnees[pointeur+3]:=(fichier^.taille and $FF000000) shr 24;

        result:=true;
    end
    else result:=false;
end;

//-------------------------------------------------------------------------------------------
//Cration d'image disque vierge *.ST
procedure creation_disquette_vierge(faces:integer; secteurs:smallint; pistes:smallint;
                                    taille_secteur:smallint; secteurs_par_cluster:smallint;
                                    entrees_rep_principal:smallint; secteurs_par_fat:byte;
                                    nomfichier:string);
var
    taille:integer;
    buf:array of byte;
    fichier:tfilestream;

begin
    taille:=faces*secteurs*pistes*taille_secteur;

    setlength(buf,taille);

    buf[11]:=lo(taille_secteur);        //Taille secteur en octets (octet de poids faible)
    buf[12]:=hi(taille_secteur);        //Taille secteur en octets (octet de poids fort)
    buf[13]:=secteurs_par_cluster;      //Nombre de secteurs par cluster
    buf[16]:=2;                         //Nombre de FATs
    buf[17]:=lo(entrees_rep_principal); //Nombre d'entres dans le rpertoire racine (octet de poids faible)
    buf[18]:=hi(entrees_rep_principal); //Nombre d'entres dans le rpertoire racine (octet de poids fort)
    buf[19]:=lo(secteurs*faces*pistes); //Nombre total de secteurs (octet de poids faible)
    buf[20]:=hi(secteurs*faces*pistes); //Nombre total de secteurs (octet de poids fort)
    buf[22]:=secteurs_par_fat;          //Nombre de secteurs par FAT
    buf[24]:=lo(secteurs);              //Nombre de secteurs (octet de poids faible)
    buf[25]:=hi(secteurs);              //Nombre de secteurs (octet de poids fort)
    buf[26]:=lo(faces);                 //Nombre de faces (octet de poids faible)
    buf[27]:=hi(faces);                 //Nombre de faces (octet de poids fort)

    fichier := TFileStream.Create(nomfichier,fmCreate);
    fichier.Seek(0,soFromBeginning);
    fichier.Write(buf[0],taille);
    fichier.free;
    setlength(buf,0);
end;

//-------------------------------------------------------------------------------------------
//Augmente la taille d'un sous-rpertoire d'un cluster si possible
//Si OK renvoie le numro du nouveau cluster, si pas OK renvoie -1
function extension_sous_repertoire(dernier_cluster:integer; image:p_imagedisk):integer;
var
    num_cluster:integer;
    pointeur:integer;
    compteur:integer;

begin
    if comptage_clusters(1,image)>0 then
    begin
        num_cluster:=1;
        repeat
            inc(num_cluster);
        until (lire_etat_cluster(num_cluster,image)=0);
        ecrire_etat_cluster(dernier_cluster,num_cluster,image);
        ecrire_etat_cluster(num_cluster,$FFF,image);
        pointeur:=(num_cluster-2)*image.taille_cluster;
        pointeur:=pointeur+image.adr_debut_rep+(image.entrees_rep_principal shl 5);
        for compteur:=0 to image.taille_cluster do image.donnees[pointeur+compteur]:=0;
        result:=num_cluster;
    end
    else result:=-1;
end;

//-------------------------------------------------------------------------------------------
//Cre un nouveau rpertoire
//Si OK renvoie le numro du premier cluster du nouveau rpertoire
//Si pas OK renvoie -1
function creation_repertoire(nom_rep:string; niveau_rep_dest:integer; cluster_rep_dest:integer; image:p_imagedisk):integer;
var
    pointeur_rep:integer;
    autorisation_rep:boolean;
    repertoire:entree_fat;
    num_cluster:integer;
    data:byte;
    pointeur:integer;
    index:integer;
    resultat_ecriture:boolean;
    etat_cluster:integer;
    pointeur_entree_rep:integer;
    compteur:integer;

begin
    num_cluster:=0;
    autorisation_rep:=true;
    resultat_ecriture:=true;
    
    //Vrifie la prsence d'un cluster libre sur la disquette destination
    if comptage_clusters(1,image)>0 then
    begin

        //Adresse du dbut du rpertoire destination
        if niveau_rep_dest=0 then pointeur_rep:=image^.adr_debut_rep
        else begin
            pointeur_rep:=(cluster_rep_dest-2)*image^.taille_cluster;
            pointeur_rep:=pointeur_rep+image^.adr_debut_rep+(image^.entrees_rep_principal shl 5);
        end;

        //Recherche la premire entre libre dans le sous-rpertoire destination
        num_cluster:=cluster_rep_dest;
        index:=0;
        pointeur_entree_rep:=0;
        pointeur:=pointeur_rep;
        if niveau_rep_dest>0 then
        repeat
            data:=image^.donnees[pointeur+index];
            if (data<>$00) and (data<>$e5) then
            begin
                inc(index,32);
                if (index=image^.taille_cluster) then
                begin
                    etat_cluster:=lire_etat_cluster(num_cluster,image);
                    if (etat_cluster>=$001) and (etat_cluster<=$fef) then num_cluster:=etat_cluster
                    else begin
                        //Si pas d'entre libre, extension du sous-rpertoire
                        num_cluster:=extension_sous_repertoire(num_cluster,image);
                        if num_cluster=-1 then autorisation_rep:=false;
                    end;
                    if autorisation_rep=true then
                    begin
                        pointeur:=(num_cluster-2)*image^.taille_cluster;
                        pointeur:=pointeur+image^.adr_debut_rep+(image^.entrees_rep_principal shl 5);
                    end;
                    index:=0;
                end;
            end
            else pointeur_entree_rep:=pointeur+index;
        until (autorisation_rep=false) or (pointeur_entree_rep<>0)
        else repeat
            //Recherche la premire entre libre dans le rpertoire racine
            data:=image^.donnees[pointeur+index];
            if (data=$00) or (data=$e5) then pointeur_entree_rep:=pointeur+index
            else begin
                inc(index,32);
                if ((index shr 5)>=image^.entrees_rep_principal-1) then autorisation_rep:=false;
            end;
        until (autorisation_rep=false) or (pointeur_entree_rep<>0);

        if autorisation_rep=true then
        begin
            //recherche du premier cluster libre
            num_cluster:=1;
            repeat
                inc(num_cluster);
            until (lire_etat_cluster(num_cluster,image)=0);

            //Informations sur rpertoire  crer
            repertoire.nom:=nom_rep;
            repertoire.taille:=0;
            repertoire.heure:=timetostr(now);
            repertoire.date:=datetostr(now);
            repertoire.attributs:=$10;
            repertoire.premier_cluster:=num_cluster;
            repertoire.adresse_declaration:=pointeur_entree_rep;

            //Ecriture entre dans rpertoire destination
            if niveau_rep_dest=0 then resultat_ecriture:=ecrire_entree_rep(0,niveau_rep_dest,@repertoire,true,image)
            else resultat_ecriture:=ecrire_entree_rep(cluster_rep_dest,niveau_rep_dest,@repertoire,true,image);

            if resultat_ecriture=true then
            begin
                pointeur_entree_rep:=(num_cluster-2)*image^.taille_cluster;
                pointeur_entree_rep:=pointeur_entree_rep+image^.adr_debut_rep+(image^.entrees_rep_principal shl 5);

                //Effacement des donnes du cluster choisi
                for compteur:=0 to image^.taille_cluster do image^.donnees[pointeur_entree_rep+compteur]:=0;

                //Cration des deux entres '.' et '..' dans le nouveau rpertoire
                repertoire.nom:='.          ';
                repertoire.premier_cluster:=num_cluster;
                repertoire.adresse_declaration:=pointeur_entree_rep;
                ecrire_entree_rep(cluster_rep_dest,1,@repertoire,false,image);

                repertoire.nom:='..         ';
                repertoire.premier_cluster:=cluster_rep_dest;
                repertoire.adresse_declaration:=pointeur_entree_rep+32;
                ecrire_entree_rep(cluster_rep_dest,1,@repertoire,false,image);

                //Ecriture entre dans la FAT
                ecrire_etat_cluster(num_cluster,$FFF,image);
            end;
        end;
    end
    else autorisation_rep:=false;

    if (autorisation_rep=false) or (resultat_ecriture=false) then result:=-1
        else result:=num_cluster;
end;

//-------------------------------------------------------------------------------------------
//Effacement d'une arborescence de rpertoires
procedure effacement_repertoire(premier_cluster:integer; adr_entree_fat:integer; image:p_imagedisk);
var
    taille_cluster:integer;
    index:integer;
    pointeur:integer;
    cluster_suivant:integer;
    cluster_temp:integer;
    data:byte;
    cluster_sous_rep:integer;
    adr_sous_rep:integer;

begin
    image^.donnees[adr_entree_fat]:=$e5;
    taille_cluster:=image^.taille_cluster;
    index:=0;
    cluster_suivant:=premier_cluster;
    pointeur:=(cluster_suivant-2)*taille_cluster;
    pointeur:=pointeur+image^.adr_debut_rep+(image^.entrees_rep_principal shl 5);
    repeat
        data:=image^.donnees[pointeur+index];
        if data<>$e5 then
            if char(data)='.' then image^.donnees[pointeur+index]:=$e5
            else begin
                data:=image^.donnees[pointeur+index+11] and $10;
                if data<>0 then
                begin
                    //Si l'entre suivante est un rpertoire, effacement de ce rpertoire
                    cluster_sous_rep:=image^.donnees[pointeur+index+26];
                    cluster_sous_rep:=cluster_sous_rep+(image^.donnees[pointeur+index+27] shl 8);
                    adr_sous_rep:=pointeur+index;
                    effacement_repertoire(cluster_sous_rep,adr_sous_rep,image);
                end
                    // Sinon effacement du fichier
                else effacement_fichier(pointeur+index,image);
            end;

        inc(index,32);
        if index>=taille_cluster then
        begin
            cluster_temp:=cluster_suivant;
            cluster_suivant:=lire_etat_cluster(cluster_suivant,image);
            ecrire_etat_cluster(cluster_temp,0,image);
            index:=0;
            pointeur:=(cluster_suivant-2)*taille_cluster;
            pointeur:=pointeur+image^.adr_debut_rep+(image^.entrees_rep_principal shl 5);
        end;
    until (cluster_suivant>4080) or (cluster_suivant<2);
end;

//-------------------------------------------------------------------------------------------
//Transfert de fichier sur une image disque
// OK=1
// Pas OK=0
function transfert_fichier(fichier:p_entree_fat;var buffer:array of byte; cluster_rep_dest:integer; disquette:p_imagedisk):integer;
var
    pointeur:integer;
    pointeur_entree_rep:integer;
    index:integer;
    data:byte;
    calcul:integer;

    //Variables pour calcul clusters ncessaires pour fichiers  transfrer
    taille_cluster:integer;
    taille_fichier:integer;
    transfert_clusters_fichiers:integer;

    //Variables pour transfert de fichiers
    autor_transfert:boolean;
    niveau_rep:integer;
    pointeur_rep:integer;
    num_cluster:integer;
    etat_cluster:integer;
    ecriture_entree_ok:boolean;

begin
    autor_transfert:=true;

    //Adresse du dbut du rpertoire destination
    if cluster_rep_dest=0 then niveau_rep:=0 else niveau_rep:=1;

    if niveau_rep=0 then pointeur_rep:=disquette^.adr_debut_rep
    else begin
        pointeur_rep:=(cluster_rep_dest-2)*disquette.taille_cluster;
        pointeur_rep:=pointeur_rep+disquette^.adr_debut_rep+(disquette^.entrees_rep_principal shl 5);
    end;

    //Transfert des fichiers
    index:=0;
    pointeur_entree_rep:=0;
    pointeur:=pointeur_rep;
    if niveau_rep>0 then
    begin
        //Recherche la premire entre libre dans le sous-rpertoire destination
        num_cluster:=cluster_rep_dest;
        repeat
            data:=disquette^.donnees[pointeur+index];
            if (data<>$00) and (data<>$e5) then
            begin
                inc(index,32);
                if (index>=disquette^.taille_cluster) then
                begin
                    etat_cluster:=lire_etat_cluster(num_cluster,disquette);
                    if (etat_cluster>=$001) and (etat_cluster<=$fef) then num_cluster:=etat_cluster
                    else begin
                        //Si pas d'entre libre, extension du sous-rpertoire
                        num_cluster:=extension_sous_repertoire(num_cluster,disquette);
                        if num_cluster=-1 then autor_transfert:=false;
                    end;
                    if autor_transfert=true then
                    begin
                        pointeur:=(num_cluster-2)*disquette^.taille_cluster;
                        pointeur:=pointeur+disquette^.adr_debut_rep+(disquette^.entrees_rep_principal shl 5);
                    end;
                    index:=0;
                end;
            end
            else pointeur_entree_rep:=pointeur+index;
        until (autor_transfert=false) or (pointeur_entree_rep<>0);
    end
    else repeat
        //Recherche la premire entre libre dans le rpertoire racine
        data:=disquette^.donnees[pointeur+index];
        if (data=$00) or (data=$e5) then pointeur_entree_rep:=pointeur+index
        else begin
            inc(index,32);
            if ((index shr 5)>=disquette^.entrees_rep_principal-1) then autor_transfert:=false;
        end;
    until (autor_transfert=false) or (pointeur_entree_rep<>0);

    //Calcul du nombre de clusters ncessaires au transfert du fichier
    transfert_clusters_fichiers:=0;
    taille_fichier:=fichier.taille;
    taille_cluster:=disquette^.taille_cluster;

    calcul:=taille_fichier div taille_cluster;
    if (calcul*taille_cluster<taille_fichier) then inc(calcul);
    inc(transfert_clusters_fichiers,calcul);

    //Vrifie que l'espace est suffisant sur la disquette
    if comptage_clusters(1,disquette)<transfert_clusters_fichiers then autor_transfert:=false;

    if autor_transfert=true then
    begin
        //Recherche du premier cluster libre
        num_cluster:=1;
        repeat
            inc(num_cluster);
        until lire_etat_cluster(num_cluster,disquette)=0;

        //Prparation des infos sur le fichier
        fichier.attributs:=0;
        fichier.premier_cluster:=num_cluster;
        fichier.adresse_declaration:=pointeur_entree_rep;

        //Ecriture entre dans rpertoire
        if niveau_rep=0 then ecriture_entree_ok:=ecrire_entree_rep(0,niveau_rep,fichier,true,disquette)
            else ecriture_entree_ok:=ecrire_entree_rep(cluster_rep_dest,niveau_rep,fichier,true,disquette);

        //Transfert donnes fichier
        if ecriture_entree_ok then ecriture_fichier(fichier,buffer,disquette);

        result:=1;
    end
    else result:=0;
end;

//-------------------------------------------------------------------------------------------
//Extraction d'un fichier depuis une image disque *.ST
procedure extraire_fichier(numero_entree:integer; image:p_imagedisk; var buffer:array of byte);
var
    pointeur_sour:integer;
    pointeur_dest:integer;
    cluster_suivant:integer;
    taille:integer;
    octets_restants:integer;

begin
    pointeur_sour:=(image^.contenu_img[numero_entree].premier_cluster-2)*image^.taille_cluster;
    pointeur_sour:=pointeur_sour+image^.adr_debut_rep+(image^.entrees_rep_principal shl 5);

    taille:=length(buffer);
    pointeur_dest:=0;
    octets_restants:=taille;

    if taille<=image^.taille_cluster then
        copymemory(@buffer[0],@image^.donnees[pointeur_sour],taille)
    else begin
        cluster_suivant:=image^.contenu_img[numero_entree].premier_cluster;
        while (octets_restants>0) do
        begin
            if octets_restants<=image^.taille_cluster then
            begin
                copymemory(@buffer[pointeur_dest],@image^.donnees[pointeur_sour],octets_restants);
                dec(octets_restants,octets_restants)
            end
            else begin
                copymemory(@buffer[pointeur_dest],@image^.donnees[pointeur_sour],image^.taille_cluster);
                dec(octets_restants,image^.taille_cluster);
                inc(pointeur_dest,image^.taille_cluster);

                cluster_suivant:=lire_etat_cluster(cluster_suivant,image);
                if (cluster_suivant>=2) and (cluster_suivant<=4080) then
                begin
                    pointeur_sour:=(cluster_suivant-2)*image^.taille_cluster;
                    pointeur_sour:=pointeur_sour+image^.adr_debut_rep+(image^.entrees_rep_principal shl 5);
                end
                else octets_restants:=0;
            end;
        end;
    end;
end;

//-------------------------------------------------------------------------------------------
//Lit les informations de l'image disque (faces,secteurs ...)
procedure lire_infos_image_disque(image:p_imagedisk;messages:boolean);
var
    taillefichier:integer;
    identifieur:word;
    sectors:word;
    sides:word;
    starttrack:word;
    endtrack:word;
    taille_fat:word;
    entrees_rep:word;
    fats:byte;
    sec_par_cluster:byte;
    compression_dim:byte;
    calc_secteurs:single;
    octets_par_secteur:smallint;

    nb_total_secteurs:integer;
    calcul_taille:single;
    nb_pistes_temp:integer;
    nb_secteurs_temp:integer;
    calcul_taille_temp:single;

    stt_magic:longword;
    stt_version:word;
    stt_flags:word;
    stt_dataflags:word;
    stt_alltrackflags:word;
    stt_numtracks:smallint;
    stt_numsides:smallint;
    stt_face:integer;
    stt_piste:integer;
    stt_secteur:integer;
    stt_trackstart:array[1..2,1..86] of longword;
    stt_nb_secteurs: word;
    stt_nb_secteurs_mem: word;
    stt_num_nb_secteurs: integer;
    stt_taille_secteurs: byte;
    stt_taille_secteurs_mem: byte;
    stt_num_taille_secteurs: integer;
    stt_pointeur:integer;

    sorte_fichier:string;

begin
    with image^ do
    begin
        fichier_ok:= false;
        sorte:=extraire_type_fichier(nomfichier);
        sorte:=lowercase(sorte);
        sorte_fichier:=sorte;
        taillefichier:=length(donnees);

    //Format .msa
        if sorte='msa' then
        begin
            copymemory(@identifieur,@donnees[0],2);
            copymemory(@sectors,@donnees[2],2);
            copymemory(@sides,@donnees[4],2);
            copymemory(@starttrack,@donnees[6],2);
            copymemory(@endtrack,@donnees[8],2);

            identifieur:=mem_st_pc(identifieur);
            sectors:=mem_st_pc(sectors);
            sides:=mem_st_pc(sides) + 1;
            starttrack:=mem_st_pc(starttrack);
            endtrack:=mem_st_pc(endtrack);

            if (sectors>0) and (sides in [1..2]) and (starttrack in [0..endtrack-1])
                and (endtrack in [starttrack+1..86]) then
            begin
                nbsecteurs:=sectors;
                nbfaces:=sides;
                piste_depart:=starttrack;
                piste_fin:=endtrack;
                taille:=taillefichier;
                taille_secteur:=512;
                fichier_ok:=true;
            end
            else if messages then MessageDlg(textes_general[110]+nomfichier, mtInformation, [mbOk], 0);
        end

//Format .st
        else if sorte='st' then begin
            copymemory(@octets_par_secteur,@donnees[11],2);
            copymemory(@sec_par_cluster,@donnees[13],1);
            copymemory(@fats,@donnees[16],1);
            copymemory(@entrees_rep,@donnees[17],2);
            copymemory(@endtrack,@donnees[19],2);
            copymemory(@taille_fat,@donnees[22],2);
            copymemory(@sectors,@donnees[24],2);
            copymemory(@sides,@donnees[26],2);

            if (sectors<>0) and (sides<>0) then endtrack:=endtrack div (sectors*sides);

            //Si taille de secteur incorrecte, valeur force  512 octets
            if (octets_par_secteur<>128) and (octets_par_secteur<>256)
                 and (octets_par_secteur<>512) and (octets_par_secteur<>1024)
                 then octets_par_secteur:=512;

            if (octets_par_secteur*sectors*endtrack*sides)<>taillefichier then
            begin       // Si infos boot-sector mauvaises, recherche par calcul
                nb_total_secteurs:=taillefichier div octets_par_secteur;
                if nb_total_secteurs>=1100 then sides:=2 else sides:=1;
                //Premier essai : recherche de la taille exacte
                sectors:=8;
                endtrack:=76;
                repeat
                    calcul_taille:=sectors*endtrack*sides*octets_par_secteur;
                    if calcul_taille=taillefichier then fichier_ok:=true
                    else begin
                        inc(sectors);
                        if sectors>27 then
                        begin
                            sectors:=8;
                            inc(endtrack);
                        end;
                    end;
                until (fichier_ok=true) or (endtrack>86);
                //Deuxime essai : recherche taille la plus proche
                if not fichier_ok then
                begin
                    sectors:=26;
                    endtrack:=86;
                    nb_secteurs_temp:=sectors;  //Pour viter un avertissement du compilateur
                    nb_pistes_temp:=endtrack;   //Pour viter un avertissement du compilateur
                    calcul_taille_temp:=10;
                    repeat
                        calcul_taille:=taillefichier/(sectors*endtrack*sides*octets_par_secteur);
                        if (calcul_taille>=1) and (calcul_taille<calcul_taille_temp) then
                        begin
                            nb_secteurs_temp:=sectors;
                            nb_pistes_temp:=endtrack;
                            calcul_taille_temp:=taillefichier/(nb_secteurs_temp*nb_pistes_temp*sides*octets_par_secteur);
                        end;
                        dec(sectors);
                        if sectors<8 then
                        begin
                            sectors:=26;
                            dec(endtrack);
                        end;
                    until (endtrack<76);
                    sectors:=nb_secteurs_temp;
                    endtrack:=nb_pistes_temp;
                    fichier_ok:=true;
                end;
            end
            else fichier_ok:=true;

            if fichier_ok then
            begin
                //Copie des donnes lues
                //Si donne manquante, forage  la valeur par dfaut
                nbsecteurs:=sectors;
                nbfaces:=sides;
                piste_depart:=0;
                piste_fin:=endtrack-1;
                if fats<>0 then nbfats:=fats else nbfats:=2;
                taille_secteur:=octets_par_secteur;
                if sec_par_cluster<>0 then secteurs_par_cluster:=sec_par_cluster else secteurs_par_cluster:=2;
                if taille_fat<>0 then secteurs_par_fat:=taille_fat else secteurs_par_fat:=5;
                if entrees_rep<>0 then entrees_rep_principal:=entrees_rep else entrees_rep_principal:=112;
                taille:=taillefichier;

                adr_debut_rep:=(fats*taille_fat)*octets_par_secteur+octets_par_secteur;
                taille_cluster:=sec_par_cluster*octets_par_secteur;
            end
            else if messages then MessageDlg(textes_general[110]+nomfichier, mtInformation, [mbOk], 0);
        end

//Format .dim
        else if sorte='dim' then begin
            sectors:=0;
            sides:=0;
            starttrack:=0;
            endtrack:=0;

            copymemory(@identifieur,@donnees[0],2);
            copymemory(@compression_dim,@donnees[3],1);
            copymemory(@sides,@donnees[6],1);
            copymemory(@sectors,@donnees[8],1);
            copymemory(@starttrack,@donnees[10],1);
            copymemory(@endtrack,@donnees[12],1);

            identifieur:=mem_st_pc(identifieur);
            inc(sides);

            calc_secteurs:=0;
            if (sectors*(endtrack-starttrack+1)*sides)<>0 then
                calc_secteurs:=(taillefichier-32)/(sectors*(endtrack-starttrack+1)*sides);
            octets_par_secteur:=trunc(calc_secteurs);

            if ((octets_par_secteur=128) or (octets_par_secteur=256) or (octets_par_secteur=512)
                or (octets_par_secteur=1024)) and (compression_dim=0) then fichier_ok:=true;

            if fichier_ok then
            begin
                nbsecteurs:=sectors;
                nbfaces:=sides;
                piste_depart:=starttrack;
                piste_fin:=endtrack;
                taille:=taillefichier;
                taille_secteur:=octets_par_secteur;
            end
            else if messages then MessageDlg(textes_general[110]+nomfichier, mtInformation, [mbOk], 0);
        end

//Format .stt
        else if sorte='stt' then begin
            copymemory(@stt_magic,@donnees[0],4);
            copymemory(@stt_version,@donnees[4],2);
            copymemory(@stt_flags,@donnees[6],2);
            copymemory(@stt_alltrackflags,@donnees[8],2);
            copymemory(@stt_numtracks,@donnees[10],2);
            copymemory(@stt_numsides,@donnees[12],2);

            stt_num_taille_secteurs:=0;
            stt_taille_secteurs_mem:=0;
            stt_num_nb_secteurs:=0;
            stt_nb_secteurs_mem:=0;

            if (stt_magic=1296389203) and (stt_version=1) and (stt_alltrackflags and 1=1) then
            begin
                stt_pointeur:=14;
                //Lecture des adresses de dbut des pistes
                for stt_face:=1 to stt_numsides do
                    for stt_piste:=1 to stt_numtracks do
                    begin
                        copymemory(@stt_trackstart[stt_face,stt_piste],@donnees[stt_pointeur],4);
                        inc(stt_pointeur,6);
                    end;

                //Contrle que toutes les pistes contiennent le mme nombre de secteurs
                //et que tous les secteurs font la mme taille
                for stt_face:=1 to stt_numsides do
                    for stt_piste:=1 to stt_numtracks do
                    begin
                        stt_pointeur:=stt_trackstart[stt_face,stt_piste];
                        copymemory(@stt_magic,@donnees[stt_pointeur],4);
                        inc(stt_pointeur,4);
                        copymemory(@stt_dataflags,@donnees[stt_pointeur],2);
                        inc(stt_pointeur,2);
                        if (stt_magic=1262703188) and (stt_dataflags and 1=1) then
                        begin
                            inc(stt_pointeur,4);
                            copymemory(@stt_nb_secteurs,@donnees[stt_pointeur],2);
                            inc(stt_pointeur,5);
                            if stt_nb_secteurs<>0 then
                                if ((stt_nb_secteurs_mem<>stt_nb_secteurs) and (stt_nb_secteurs<>0))
                                    or (stt_nb_secteurs_mem=0) then
                                begin
                                    inc(stt_num_nb_secteurs);
                                    stt_nb_secteurs_mem:=stt_nb_secteurs;
                                end;
                            for stt_secteur:=1 to stt_nb_secteurs do
                            begin
                                copymemory(@stt_taille_secteurs,@donnees[stt_pointeur],1);
                                inc(stt_pointeur);
                                if stt_taille_secteurs<>0 then
                                    if ((stt_taille_secteurs_mem<>stt_taille_secteurs) and (stt_taille_secteurs<>0))
                                        or (stt_taille_secteurs_mem=0) then
                                    begin
                                        inc(stt_num_taille_secteurs);
                                        stt_taille_secteurs_mem:=stt_taille_secteurs;
                                    end;

                                inc(stt_pointeur,9);
                            end;
                        end;
                    end;

                if (stt_num_taille_secteurs=1) and (stt_num_nb_secteurs=1) then fichier_ok:=true
                else if messages then MessageDlg(textes_general[111]+nomfichier, mtInformation, [mbOk], 0);
            end
            else if messages then MessageDlg(textes_general[110]+nomfichier, mtInformation, [mbOk], 0);

            if fichier_ok then
            begin
                nbsecteurs:=stt_nb_secteurs_mem;
                taille_secteur:=128 shl stt_taille_secteurs_mem;
                nbfaces:=stt_numsides;
                piste_depart:=0;
                piste_fin:=stt_numtracks-1;
                taille:=taillefichier;
            end;
        end;
    end;
end;

//-------------------------------------------------------------------------------------------
//Conversion des donnes mmoire ST en donnes PC et vice-versa
//par inversion des octets de poids faible et de poids fort
function mem_st_pc(donnee:word):word;
var
    poids_fort,poids_faible: word;

begin
    poids_fort := (donnee and $FF) shl 8;
    poids_faible := (donnee and $FF00) shr 8;
    result:= poids_faible or poids_fort;
end;

//-------------------------------------------------------------------------------------------
//Gestion des paramtres passs en ligne de commande
//
// 1- msa "user_path" "folder"
// 2- msa "convert" "disk image" "destination format" "nb of files for msa"
// 3- msa "diskimg_to_hdisk" "disk image" "folder"
// **** A ECRIRE ****    4- msa "hdisk_to_diskimg" "folder" "disk image"    **** A ECRIRE ****
// 5- msa "zip_to_diskimg" "file.zip" "destination file.st"
// 6- msa "disk image"
//
// paramtres supplmentaires:
// "zip" active la compression ZIP pour 2  4
// "exit" quitte en fin de traitement pour 2  4
// "show" affiche la ligne de commande reue
procedure parametres_en_ligne;
var
    nouv_mdi:tmdichild;
    commande:string;
    dest_format:string;
    type_img_source:string;
    nom_temp:string;
    nbparam:integer;
    compteur:integer;
    nb_msa:integer;
    resultat:boolean;
    quitte:boolean;
    compresse:boolean;
    affiche:boolean;

    num_parent:integer;
    num_parent_suivant:integer;
    rep_destination:string;
    buffer_fichier:array of byte;
    fichier:tfilestream;
    nb_copies:integer;

begin
    nbparam:=paramcount;
    resultat:=false;
    quitte:=false;
    compresse:=false;
    affiche:=false;
    commande:=lowercase(ParamStr(1));

    //Contrle s'il faut afficher la ligne de commande
    for compteur:=0 to nbparam do
        if paramstr(compteur)='show' then affiche:=true;
    if affiche then MessageDlg(cmdline, mtInformation, [mbOk], 0);

    //Contrle s'il faut quitter aprs l'opration demande
    for compteur:=0 to nbparam do
        if paramstr(compteur)='exit' then quitte:=true;

    //Contrle s'il faut compresser l'image disque obtenue
    for compteur:=0 to nbparam do
        if paramstr(compteur)='zip' then compresse:=true;

    //Analyse des commandes reues
    //
    //Commande 1 : Dfinition du rpertoire utilisateur
    //msa "user_path" "folder"
    if commande='user_path' then
    begin
        if nbparam>=2 then
            if directoryexists(paramstr(2)) then
            begin
                resultat:=true;
                rep_utilisateur:=ParamStr(2);
            end;
    end else

    //Commande 2 : Conversion de format d'une image disque
    //msa "convert" "disk image" "destination format" "nb of files for msa"
    if commande='convert' then
    begin
        if nbparam>=3 then
        begin
            dest_format:=lowercase(paramstr(3));
            if (fileexists(paramstr(2)) and ((dest_format='msa') or (dest_format='st'))) then
            begin
                type_img_source:=lowercase(extraire_type_fichier(paramstr(2)));
                if (type_img_source ='st') or
                    (type_img_source ='msa') or
                    (type_img_source ='dim') or
                    (type_img_source ='stt') or
                    (type_img_source ='zip') then
                begin
                    convert.show;
                    convert.liste_fichiers.Items.add(nil,paramstr(2));
                    nb_msa:=1;
                    if nbparam>=4 then
                        try
                            nb_msa:=strtoint(paramstr(4));
                        except
                            nb_msa:=1;
                        end;
                    convert.choix_nombre_msa.ItemIndex:=nb_msa-1;
                    if (type_img_source<>'zip') and compresse then convert.compresser.Checked:=true
                        else convert.compresser.Checked:=false;
                    convert.ecraser_sans_confirm.Checked:=true;
                    convert.demande_conversion(dest_format);
                    resultat:=true;
                    if quitte then application.terminate;
                end;
            end;
        end;
    end else

    //Commande 3 : Transfert du contenu d'une image disque vers un rpertoire
    //msa "diskimg_to_hdisk" "disk image" "folder"
    if commande='diskimg_to_hdisk' then
    begin
        if nbparam>=3 then
            if fileexists(paramstr(2)) then
            begin
                MSA_Converter.selecfichier.filename:=paramstr(2);
                nouv_mdi:=TMDIChild.Create(MSA_Converter);
                if nouv_mdi.disquette.fichier_ok then
                    with nouv_mdi.disquette do
                    begin
                        rep_destination:=paramstr(3)+'\';
                        num_parent:=0;
                        nb_copies:=0;
                        repeat
                            num_parent_suivant:=9999;
                            for compteur:=0 to nb_entrees_fat-1 do
                            begin
                                // Si rpertoire -> cration
                                if contenu_img[compteur].sorte='dir' then
                                begin
                                    createdir(rep_destination+contenu_img[compteur].chemin+contenu_img[compteur].nom);
                                    if (contenu_img[compteur].numero>num_parent)
                                        and (contenu_img[compteur].numero<num_parent_suivant) then
                                        num_parent_suivant:=contenu_img[compteur].numero;
                                    inc(nb_copies);
                                end;

                                // Si fichier -> extrait dans le rpertoire de destination
                                if contenu_img[compteur].sorte='file' then
                                    if contenu_img[compteur].parent=num_parent then
                                    begin
                                        nomfichier:=rep_destination+contenu_img[compteur].chemin+contenu_img[compteur].nom;
                                        taille:=contenu_img[compteur].taille;
                                        setlength(buffer_fichier,taille);
                                        extraire_fichier(contenu_img[compteur].numero-1,@nouv_mdi.disquette,buffer_fichier);
                                        fichier:= TFileStream.Create(nomfichier,fmCreate);
                                        fichier.Seek(0,soFromBeginning);
                                        fichier.Write(buffer_fichier[0],taille);
                                        fichier.free;
                                        setlength(buffer_fichier,0);
                                        inc(nb_copies);
                                    end;
                            end;
                            if num_parent_suivant<>9999 then num_parent:=num_parent_suivant;
                        until nb_copies>=nouv_mdi.disquette.nb_entrees_fat;
                    resultat:=true;
                end;
                nouv_mdi.Close;
            end;
    end else

//-------------------------------------------------------------------------------------------
//                 **** A ECRIRE ****

    //Commande 4 : Transfert du contenu d'un rpertoire vers une image disque
    //msa "hdisk_to_diskimg" "folder" "disk image"
    if commande='diskimg_to_hdisk' then
    begin
        resultat:=true;
        if quitte then application.terminate;
    end else
//-------------------------------------------------------------------------------------------


    //Commande 5 : Conversion d'un fichier ZIP en image disque ST
    //(ajout pour la compatibilit avec STEEM disk manager V3.1)
    //msa "zip_to_diskimg" "file.zip" "destination file.st"
    if commande='zip_to_diskimg' then
    begin
        if nbparam>=3 then
        begin
            dest_format:='st';
            if (fileexists(paramstr(2)) and (dest_format='st')) then
            begin
                type_img_source:=lowercase(extraire_type_fichier(paramstr(2)));
                if (type_img_source ='zip') then
                begin
                    convert.show;
                    convert.liste_fichiers.Items.add(nil,paramstr(2));
                    nb_msa:=1;
                    convert.choix_nombre_msa.ItemIndex:=nb_msa-1;
                    convert.compresser.Checked:=false;
                    convert.ecraser_sans_confirm.Checked:=true;
                    convert.demande_conversion(dest_format);
                    resultat:=true;
                    if quitte then application.terminate;
                end;
            end;
        end;
    end else

    //Commande 6 : Ouverture d'une image disque
    //msa "disk image"
    if resultat=false then
    begin
        nom_temp:=lowercase(paramstr(1));
        if extraire_type_fichier(nom_temp)='' then nom_temp:=nom_temp+'.st';
        if fileexists(nom_temp) then
        begin
            MSA_Converter.selecfichier.filename:=paramstr(1);
            rep_utilisateur:=extraire_repertoire(paramstr(1));
            nouv_mdi:=TMDIChild.Create(MSA_Converter);
            if nouv_mdi.disquette.fichier_ok=false then nouv_mdi.Close
                else resultat:=true;
        end;
    end;

    //Paramtre incorrect
    if resultat=false then
    begin
        MessageDlg(textes_general[126], mtInformation, [mbOk], 0);
        MessageDlg(cmdline, mtInformation, [mbOk], 0)
    end;
end;

end.

